{*************************************************************************}
{*                                                                       *}
{*                                                                       *}
{*                   PROGRAM :     GOMOKU                                *}
{*     OSTATNIA AKTUALIZACJA :     04.01.2005                            *}
{*                                                                       *}
{*                   AUTORZY :     S. KOGUT, K. SKOCZYLAS                *}
{*                                                                       *}
{*                                                                       *}
{*                                                                       *}
{*************************************************************************}


USES
   Standard, GomokuAI, MouseX, Graph10E, Keyb_X, Fonts, Doors,
   Doors_EV, Doors10E, Buttons;

CONST MaxBMP=5;
      MaxBtn=4;

      StrBtn=1;

 	    PX=40;
	    PY=2;

	    MaxEX=320;
      MaxEY=200;

  	  SzerK=16;
      WysK=13;

      MaxW=15;
      MaxH=15;

      WW=172;
      WH=44;

      Kat='Dane\';
      FontF='Default.Fnt';

      TextKon:ARRAY[2..3] OF STRING[30]=
      ('GRATULACJE, WYGRAE !!!','NIESTETY PRZEGRAE');

      BTxt:ARRAY[1..MaxBtn] OF STRING[10]=
      ('START GRY', 'OPCJE', 'INFO', 'KONIEC');

      TextCop : STRING='WIDNICA, STYCZE 2005';
      TextX   : STRING='KONIEC GRY';


VAR
	  i	        : Byte;
    Pal       : Pointer;
    BMP       : Array[0..MaxBMP] Of TPicture;
    TAB       : Array[1..MaxW, 1..MaxH] Of Byte;
    Buf       : TEkran10Eh;
    AX, AY    : Byte;
    LP, B, SB : Byte;
    Mx, My    : Integer;
    Sx, Sy    : Integer;
    YW, XW,
    Wygrana   : Byte;
    Lx, LY    : Integer;
    TK, SP,
    Kto       : Byte;
    Font      : PFont;
    Button    : ARRAY[1..MaxBtn] OF PObject;
    Poz       : ARRAY[1..MaxBtn] OF TPoz;
    GDx, GDy  : Integer;
    Gx, Gy    : Integer;



PROCEDURE Plansza(x, y : Byte);
VAR a, b: Byte;

BEGIN
  V_ClearScreen(Buf, 0);

  FOR b:=0 TO MaxH-1 DO
  FOR a:=0 TO MaxW-1 DO
  IF ((a+1=x) AND (b+1=y)) OR ((a+1=xw) AND (b+1=yw)) THEN
    V_KopiujObraz(Buf, BMP[TAB[a+1, b+1]], PX+a*SzerK+1, PY+b*WysK+1)
    ELSE
    V_KopiujObraz(Buf, BMP[TAB[a+1, b+1]], PX+a*SzerK, PY+b*WysK);
END;

PROCEDURE LoadBMPx;
VAR a:Byte;
    FileFont:STRING;
    Param:PButtonParams;
BEGIN

  V_GetBuf(Buf);
  F_NewFont(Font);
  FileFont:=Kat+FontF;
  F_LoadFont(Font, FileFont);

  For a:=0 to MaxBMP-1 do
  BEGIN
    V_NewImage(BMP[a]);
    IF a<MaxBMP-2 THEN BMP[a]^.Transparent:=False ELSE BMP[a]^.Transparent:=True;
    V_LoadBMP24(BMP[a], Kat+'G'+IntToStr(a+1)+'x.Bmp');
  END;

  FOR a:=1 TO MaxBtn DO
  BEGIN
    D_CreateObject(Button[a]);
    D_CreateButton(Button[a]);

    WITH Button[a]^ DO
    BEGIN
      Poz[a].X:=MaxEX SHR 1-45;
      Poz[a].Y:=PY SHL 4+20*a;
      Pos^.Width:=90;
      Pos^.Height:=16;
      Param:=Params;
      Param^.Text:=BTxt[a];
    END;
  END;
End;

PROCEDURE RozrzucButtony;
VAR a:Byte;
BEGIN
FOR a:=1 TO MaxBtn DO
    WITH Button[a]^ DO
    BEGIN
      Pos^.X:=Random(V_MaxEX{ SHL 2})-Random(V_MaxEX{ SHL 2});{(a AND 1)*-V_MaxEX+Random(V_MaxEX)+ (NOT(a AND 1))*V_MaxEX;}
      Pos^.Y:=Random(V_MaxEY{ SHL 2})-Random(V_MaxEY{ SHL 2});{(a AND 1)*-V_MaxEY+Random(V_MaxEY)+ (NOT(a AND 1))*V_MaxEY;}
    END;
END;


PROCEDURE FreeBMP;
VAR a:Byte;
BEGIN
  V_FreeBuf(Buf);
  F_FreeFont(Font);
  FOR a:=0 TO MaxBMP-1 DO V_FreeImage(BMP[a]);
  FOR a:=1 TO MaxBtn   DO D_DeleteObject(Button[a]);
END;


PROCEDURE Daz_Do(VAR X, Y:Integer; X1, Y1:Integer;S:Byte);
BEGIN
  IF (X1-X<S) THEN X:=X1;
  IF (Y1-Y<S) THEN Y:=Y1;

  X:=X+Round((X1-X)/S);
  Y:=Y+Round((Y1-Y)/S);
END;


FUNCTION MoveXY(X, Y:Byte):Byte;

VAR Wygrana:Byte;
BEGIN
  IF (X>0) AND (X<=MaxW) AND (Y>0) AND (Y<=MaxH) THEN
  BEGIN
  IF TAB[X, Y]<>0 THEN Exit;

  Wygrana:=RuszSie(X, Y, XW, YW);

  IF Wygrana<>1 THEN
     BEGIN
	     IF Wygrana<>2 THEN TAB[XW, YW]:=1 ELSE XW:=0;
       TAB[X, Y]:=2;
     END;
  END;
  MoveXY:=Wygrana;
END;

PROCEDURE Info;
VAR A:Integer;
BEGIN
        WHILE True DO
        BEGIN
          SP:=PORT[$60];
          SB:=B;
          MouseButtonsXY(Mx, My, B);

          Daz_Do(Lx, Ly, MaxEX SHR 1-WW SHR 1, MaxEY SHR 1-WH SHR 1, 10);

          Plansza(XW, YW);

          FOR A:=1 TO 10 DO
            V_HLineAlpha1(Buf, Lx, Ly+a, WW, V_RGB($FF, $88, $44), 1);
          FOR A:=10 TO WH DO
            V_HLineAlpha1(Buf, Lx, Ly+a, WW, V_RGB($FF, $BB, $00), 1);

          V_CenterText(Buf, Font, Lx+WW SHR 1, Ly+2, TextX, V_RGB($FF, $FF, $FF), 7);
          V_CenterText(Buf, Font, Lx+WW SHR 1, Ly+20, TextKon[Wygrana], V_RGB($FF, $FF, $FF), 7);

          V_KopiujObraz(Buf, BMP[3], Mx, My);
          V_VRet;
          V_FlipBuf(Buf);

          IF (SB=M_LEWY) AND (B=M_ZADEN) THEN Break;
          IF (SP<129) AND (PORT[$60]>128) THEN Break;
        END;

        XW:=0;
        YW:=0;
        REPEAT
          MouseButtonsXY(Mx, My, B);
          Daz_Do(Lx, Ly, 400, 300, 40);
          MouseButtonsXY(Mx, My, B);

          Plansza(XW, YW);

          FOR A:=1 TO 10 DO
            V_HLineAlpha1(Buf, Lx, Ly+a, WW, V_RGB($FF, $88, $44), 1);
          FOR A:=10 TO WH DO
            V_HLineAlpha1(Buf, Lx, Ly+a, WW, V_RGB($FF, $BB, $00), 1);


          V_CenterText(Buf, Font, Lx+WW SHR 1, Ly+2, TextX, V_RGB($FF, $FF, $FF), 7);
          V_CenterText(Buf, Font, Lx+WW SHR 1, Ly+20, TextKon[Wygrana], V_RGB($FF, $FF, $FF), 7);

          V_KopiujObraz(Buf, BMP[3], Mx, My);
          V_VRet;
          V_FlipBuf(Buf);

        UNTIL Lx>MaxEX;
      END;


PROCEDURE GraStart;
BEGIN
      SB:=M_ZADEN;
      B:=M_ZADEN;
      Lx:=-200;
      Ly:=-200;


      Kto:=1-Kto;
      Inicjuj(0, Kto, XW, YW);
      S_FillChar32(@TAB, MaxW*MaxH, 0);
      If Kto=1 THEN TAB[XW, YW]:=1;

      Wygrana:=0;
      SB:=M_ZADEN;
      Keyb_Init;

    REPEAT


      Sx:=Mx;
      Sy:=My;
      SB:=B;

      MouseButtonsXY(Mx, My, B);

      IF (Sx<>Mx) OR (Sy<>My) THEN
      BEGIN
        Ax:=((Mx-PX+SzerK) Div SzerK);
        Ay:=((My-PY+WysK)  Div WysK);
      END;

      IF (B=M_ZADEN) AND (SB=M_LEWY) THEN Wygrana:=MoveXY(Ax, Ay);


      IF Key[VK_RIGHT] AND (Ax<MaxW) THEN Inc(Ax);
      IF Key[VK_LEFT]  AND (Ax>1)    THEN Dec(Ax);

      IF Key[VK_DOWN]  AND (Ay<MaxH) THEN Inc(Ay);
      IF Key[VK_UP]    AND (Ay>1)    THEN Dec(Ay);

      IF Key[VK_RETURN] OR
         Key[VK_SPACE]  THEN Wygrana:=MoveXY(Ax, Ay);

      Plansza(Ax, Ay);
      V_KopiujObraz(Buf, BMP[3], Mx, My);
      V_VRet;
      V_FlipBuf(Buf);

    Until (Key[VK_ESC]) OR (Wygrana IN [2, 3]);
    IF Wygrana IN [2, 3] THEN Info;
    RozrzucButtony;
END;

VAR a:Byte;
BEGIN
	  V_Set10Eh;
    LoadBMPx;
    MouseGet;
    MouseSetMax(MaxEX-1, MaxEY-1);
    MouseXY(MaxEX SHR 1, MaxEY SHR 1);

    TK:=0;

    Ax:=MaxW shr 1+1;
    Ay:=MaxH shr 1+1;
    Wygrana:=0;
    Randomize;
    RozrzucButtony;
    Gx:=0;
    Gy:=0;

    V_ClearScreen(Buf, 0);


    WHILE True DO BEGIN

      Sx:=Mx;
      Sy:=My;
      SB:=B;
      MouseButtonsXY(Mx, My, B);

      {FOR a:=1 TO 3 DO}
      V_KopiujObraz(Buf, BMP[4], {Random(V_MaxEX), Random(V_MaxEY)}100, 10);

      FOR a:=1 TO MaxBMP DO
        Daz_DO(Button[a]^.Pos^.X, Button[a]^.Pos^.Y, Poz[a].X, Poz[a].Y, 10);

      DE_DeleteEvents;
      DE_GetEvents;

      IF DE_ObjectEvent(Button[MaxBtn], ON_MOUSE_UP) THEN Break;
      IF DE_ObjectEvent(Button[StrBtn], ON_MOUSE_UP) THEN GraStart;


      V_RozmyjEkran(Buf, 1);

      V_CenterText(Buf, Font, 160, 192, TextCOP, V_RGB($88, $88, $88), 7);

      D10_DrawAll(Buf);
      V_KopiujObraz(Buf, BMP[3], Mx, My);


      V_VRet;
      V_FlipBuf(Buf);

    END;


    Keyb_End;
    MouseRestore;
    V_End10Eh;
    WriteLn(memAvail);
    FreeBMP;
END.