{$N+}{$G+}
USES G3D, Graph10E, Standard;

CONST

    FileName = 'G3d\fig2.txt';

VAR Dane : PTriangle;
    Temp : PTriangle;
    Size : Word;

    Buf  : TEkran10Eh;

    KatX,
    KatY,
    KatZ : Byte;

    DirX : STRING;

    Vector : TVertex;
    FPS,
    NTi    : LongInt;




{PROCEDURE Blur(Buf: TEkran10Eh);ASSEMBLER;}
PROCEDURE Blur(Buf:Pointer;Size:Word);ASSEMBLER;
{VAR E1, E2 : Pointer;}

{BEGIN
  {DEKLARUJE PAMIEC DLA GORNEJ LINI
  GetMem(Temp, 640);}

  {CZYSCI PAMIEC, POTRZEBNE PRZY TWORZENIU PIERWSZEJ LINI
  S_FillChar32(Temp, 640, 0);

  E1:=Buf.Ekr1;
  E2:=Buf.Ekr2;}

  ASM
    {POBIERA ADRES PIERWSZEGO BUFORA}
    Les  Di, Buf

    {OPERACJA DLA 64000-640 LINII DLA BUFORA}
    Mov  Cx, Size

    Cld



    {POCZATEK PETLI}
    @NextPixel:

      Push Cx
      {
        Ax - czerwony
        Bx - zielony
        Cx - niebieski
        Dx - Tymczasowy rejestr
      }

      {POBIERANIE PIKSELI Z LEWEJ}
      Mov  Dx, Es:[Di-2]

      {POBIERANIE KOLOROW SKLADOWYCH}
      Mov  Ax, Dx
      Mov  Bx, Dx
      Mov  Cx, Dx

      {NAKLADANIE MASEK ZERUJACYCH NA KOLOR}
      {W CELU UZYSKANIA CZYSTEGO KOLORU}
      And  Ax, 1111100000000000b
      Shr  Ax, 11
      And  Bx, 0000011111100000b
      Shr  Ax, 5
      And  Cx, 0000000000011111b

      {POBIERANIE PIKSELI Z PRAWEJ}
      Mov  Dx, Es:[Di+2]
      And  Dx, 1111100000000000b
      Shr  Dx, 11
      Add  Ax, Dx

      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di+2]
      And  Dx, 0000011111100000b
      Shr  Dx, 5
      Add  Bx, Dx

      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di+2]
      And  Dx, 0000000000011111b
      Add  Cx, Dx

      {OMIJANIE GORNYCH PIKSELI GDY 1 RZAD}
      Cmp  Cx, Size-320
      Jna  @Dalej

      {GORNY PIKSEL}
      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di-640]
      And  Dx, 1111100000000000b
      Shr  Dx, 11
      Add  Ax, Dx

      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di-640]
      And  Dx, 0000011111100000b
      Shr  Dx, 5
      Add  Bx, Dx

      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di-640]
      And  Dx, 0000000000011111b
      Add  Cx, Dx

    @Dalej:

      {OMIJANIE DOLNYCH PIKSELI GDY OSTATNI RZAD}
      Cmp  Cx, 320
      Jnb  @JeszczeDalej

      {DOLNY PIKSEL}
      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di+640]
      And  Dx, 1111100000000000b
      Shr  Dx, 11
      Add  Ax, Dx

      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di+640]
      And  Dx, 0000011111100000b
      Shr  Dx, 5
      Add  Bx, Dx

      {POBIERANIE PIKSELI}
      Mov  Dx, Es:[Di+640]
      And  Dx, 0000000000011111b
      Add  Cx, Dx

    @JeszczeDalej:

      Shr  Ax, 2

      Shr  Bx, 2

      Shr  Cx, 2

      {BADANY PIKSEL}
      {POBIERANIE PIKSELI}

      {Mov  Dx, Es:[Di]
      And  Dx, 1111100000000000b
      Shr  Dx, 11
      Add  Ax, Dx

      {POBIERANIE PIKSELI}
      {Mov  Dx, Es:[Di]
      And  Dx, 0000011111100000b
      Shr  Dx, 5
      Add  Bx, Dx

      {POBIERANIE PIKSELI}
      {Mov  Dx, Es:[Di]         }
      {And  Dx, 0000000000011111b
      Add  Cx, Dx

      Shl  Ax, 10
      And  Ax, 1111100000000000b

      Shl  Bx, 5
      And  Bx, 0000011111100000b

      Shr  Cx, 1
      And  Cx, 0000000000011111b

      Mov  Dx, Ax
      Or   Dx, Bx
      Or   Dx, Cx

      Mov  Es:[Di], Dx

      Pop  Cx
      Inc  Di
      Inc  Di}


      Shl  Ax, 11
      And  Bx, 00000000000111111b
      Shl  Bx, 6

      And  Cx, 00000000000011111b

      Mov  Dx, Ax
      Or   Dx, Bx
      Or   Dx, Cx

      Mov  Es:[Di], Dx

      Pop  Cx
      Inc  Di
      Inc  Di

    {POWROT NA POCZATEK PETLI}

    Dec  Cx
    Or   Cx, Cx
    jnz  @NextPixel


END;



BEGIN
  DirX:=S_GetPath(ParamStr(0));

  {USTAWIA GRAFIKE}
  V_Set10Eh;

  {POBIERA PAMIEC DLA EKRANU}
  V_GetBuf(Buf);

  {WCZYTUJE DANE}
  Dane:=G3d_Load(DirX+FileName, Size);

  GetMem(Temp, Size*SizeOf(TTriangle));

  G3d_KOLOR_MGLY:=V_RGB($52, $52, $52);
  G3d_MaxOdl:=155;

  NTi:=S_Ti;
  Vector.X:=0;
  Vector.Y:=0;
  Vector.Z:=0;
  KatY:=0;



  REPEAT

    V_ClearScreen(Buf, G3d_KOLOR_MGLY);

    Inc(KatX);
    Inc(KatY);
    Inc(KatZ);

    IF KatY>=128 THEN Vector.Z:=Vector.Z-1 ELSE Vector.Z:=Vector.Z+1;

    {KOPIUJE TROJKATY}
    S_Move32(Dane, Temp, Size*SizeOf(TTriangle));

    {OBRACA I PRZESUWA OBIEKT}
    G3D_Rotate(Temp, KatX, KatY, KatZ, Size);
    G3D_Transform(Temp, @Vector, Size);

    {RYSUJE TROJKATY W BUFORZE}
    G3D_Render(Temp, Size);
    {Blur(Buf.Ekr1, 63000);
    Blur(Buf.Ekr2, 50000);}


    {POWROT}
    V_VRet;

    {PRZERYSOWUJE}
    V_FlipBuf(Buf);
    Inc(FPS);

  UNTIL PORT[$60]=1;

  {KONCZY GRAFIKE}
  V_End10Eh;

  {ZWALNIA PAMIEC DLA EKRANU}
  V_FreeBuf(Buf);

  WriteLn('FPS :',FPS*18.2/(S_Ti-NTi):10:3);

END.
