{******************************************************************

  TEKSTOWA BAZA DANYCH
    Delphi 7
    21.04.2007

******************************************************************}

unit dbText;

interface
uses dbKoder, Classes, stdFunctions, Math;

const DB_INFO = 'DBText1.0';

      DB_ROZSZERZENIE = 'dbt';

      // W trybie debuggowania bazy danych
      // warto przeczy na true
      DB_ZAPISUJ_TXT = false;
      DB_ODCZYTUJ_TXT = false;

      KLUCZ_NAZWA_TAB = 'Nazwa Tabeli';
      TABELA_SYSTEMOWA = 'system';

      SORTOWANIE_ROSNACE = 1;
      SORTOWANIE_MALEJACE = -1;
                             
        



type
  TPole = record
    sKlucz : string;
    sWartosc : string;
  end;

  PPole = ^TPole;

  TRekord = class (TList)
    function Add(const klucz, wartosc : string) : integer; overload;
    function Add(const klucz : string; wartosc : integer) : integer; overload;
    function Add(const klucz : string; wartosc : boolean) : integer; overload;
    function AddDate(const klucz : string; wartosc : TDateTime) : integer; overload;
    function Add(const klucz : string; wartosc : Real; miejsc : Integer = 0) : integer; overload;
    function Get(const klucz : string) : string;
    function GetStream(const klucz : string) : TStringStream;
    function GetF(const klucz : string) : real;
    function GetI(const klucz : string) : integer;
    function GetId(const klucz : string) : integer; // Oddaje pozycj klucza na liscie
    function Enabled : boolean; // Czy nie usunite
    function Id : integer;
    function jestWartosc(const _wartosc : string) : boolean;
    function PobierzKlucz(const s: string; var i:integer) : string;
    function PobierzWartosc(const s: string; var i:integer) : string;
    function PobierzCalosc : string;
    procedure DodajZeStringa(const s : string);
    procedure Clear; override;
    constructor Create(const s : string); overload;
    constructor Create; overload;
    function Klonuj : TRekord; 
  end;

  // DEFINICJA FUNKCJI FILTRUJCEJ DANE
  TFuncFiltruj = function (Rekord : TRekord) : Boolean;

  TDBProceduraDodajaca = procedure (Rekord : TRekord);
  TDBProceduraAktualizujacaPostep = procedure (Postep : integer);

  TDBTabela = class (TList)
     nazwa : string;
     index : integer; // Wewentrzny indeks przeszukiwania
     nast_index : integer; // Przy dodawaniu rekordw, automatycznie dodawany indeks
     Loading : Boolean;
     ZwolnijPamiec : Boolean;
     Filter : TFuncFiltruj; // Funkcja filtrujca wyniki, dziaa w powizaniu z Enabled,
                            // Jesli jej wynikiem jest false, procedury next i prev omin jej wynik

     function PobierzId : integer;
     procedure Start;
     procedure PobierzDane(_tekst : TStringList);
     procedure WczytajPlik(const _dbNazwaPliku : string);
     procedure WczytajRES(res : TResourceStream);

     function WczytajPlikCzesciowy(const _dbNazwaPliku : string; out_p : TProceduraOdbierajacaZKodera) : Boolean;
     function ZapiszPlikCzesciowy(const _dbNazwaPliku : string; in_p : TProceduraDodajacaDoKodera) : Boolean;

     procedure ZapiszPlik(const _dbNazwaPliku : string);
     procedure ZwrocDane(var _tekst : TStringList);
     procedure Usun(_id : integer);
     function ZnajdzKlucz(const key, val : string) : TRekord; overload;
     function ZnajdzKlucz(const key : string; val : Real) : TRekord; overload;
     function UsunRekordy(rekord : TRekord) : integer;
     function Add(_rekord : TRekord) : integer; overload;
     function Add(s, t: string) : integer; overload;
     function Add(s: string; r : real) : integer; overload;
     function Add(s: string; i : integer) : integer; overload;
     function Add(s: string; b : boolean) : integer; overload;
     function GetId(_id : integer) : TRekord;
     function GetIdPos(_id : integer) : integer; // Oddaje nr listy rekordu o nr id
     function Select(_rekord : TRekord) : integer;
     function SelectId(_rekord : TRekord) : integer;
     function Wyszukaj(const s : string; proc : TDBProceduraDodajaca; ListaPozycjonujaca : TDBTabela = nil) : integer;
     function WyszukajPosortowane(const s, sort : string; proc : TDBProceduraDodajaca) : integer;
     procedure Clear; override;

     destructor Destroy; override;
     constructor Create;
     function Get(const klucz : string) : string;
     function GetF(const klucz : string) : real;
     function GetI(const klucz : string) : integer;
     // Poruszanie sie po tabeli
     function Next : integer;
     function Prev : integer;
     function Koniec : boolean;
     function Poczatek : boolean;
     function Sortuj(kolumna : String) : TDBTabela;
  private
  end;

  TResult = class
    Result : Integer;
  end;

  TDBase = class (TList) // Lista obiektw TDBTabela
     dbSystem : TDBTabela; // Lista nazw plikw z tabelkami
     AktualizacjaProc : TDBProceduraAktualizujacaPostep; // Wskaznik na procedur, aktualizujc postp wczytywania / zapisu
     function Add(_tabela : TDBTabela) : integer;
     function Wczytaj(_dbKatalog : string) : integer;
     function Zapisz(_dbKatalog : string) : integer;
     function Query(const _sql : string) : TResult;
     function Tabela(const _dbNazwa : string) : TDBTabela;
     constructor Create;
     destructor Free;
  end;


function AddSlashes(const s:string) : string;
function StripSlashes(const s:string) : string;
function PorownajRekordy(r1, r2 : TRekord; koniunkcja : Boolean) : boolean;


var
  DB_SortStyle : Integer;

implementation
uses SysUtils;

// ZMIENNE DLA BAZY DANYCH
var DB_Klucz : string;


function TDBTabela.UsunRekordy(rekord : TRekord) : integer;
var tmp : TRekord;
begin
  Start;
  Result := 0;
  repeat
    if Select(rekord)>-1 then
      begin
        Inc(Result);
        tmp := TRekord(Items[index]);
        Delete(Index);
        tmp.Free;
      end;
    Next;
  until koniec;
end;       
function PorownajRekordy(r1, r2 : TRekord; koniunkcja : Boolean) : boolean;
var  i : Integer;
begin
  Result := false;
  if not r2.Enabled then exit;

  Result := true;
  
  if (koniunkcja) then
  begin
    for i:=0 to r1.Count-1 do
      if (PPole(r1.Items[i])^.sWartosc <> r2.Get(PPole(r1.Items[i])^.sKlucz)) then
      begin
        Result := false;
        Break;
      end;

  end
  else
  begin
    for i:=0 to r1.Count-1 do
      if (PPole(r1.Items[i])^.sKlucz<>'Id') and (PPole(r1.Items[i])^.sWartosc = r2.Get(PPole(r1.Items[i])^.sKlucz)) then
      begin
        Result := false;
        Break;
      end;

  end;
end;

function TDBTabela.Select(_rekord : TRekord) : integer;
var  i : Integer;
begin
  Result := -1;
  for i:=index to Count-1 do
  begin
    if PorownajRekordy(_rekord, TRekord(Items[i]), false) then
    begin
      Result :=i;
      break;
    end;
    Next;
  end;
end;

function TDBTabela.SelectId(_rekord : TRekord) : integer;
var  i : Integer;
begin
  Result := -1;
  for i:=index to Count-1 do
  begin
    if PorownajRekordy(_rekord, TRekord(Items[i]), false) then
    begin
      Result := StrToIntOk(TRekord(Items[i]).Get('Id'));
      break;
    end;
    Next;
  end;
end;

function PorownajNapisyListy(Item1, Item2 : Pointer) : integer;
var tmp1, tmp2 : string;
    l1, l2 : Real;
begin
  tmp1 := TRekord(Item1).Get(DB_Klucz); l1 := Liczba(tmp1);
  tmp2 := TRekord(Item2).Get(DB_Klucz); l2 := Liczba(tmp2);

  if (l1=0) or (l2=0) or (Napis(l1)<>tmp1) or (Napis(l2)<>tmp2) then
    Result := StrIComp(PChar(tmp1), PChar(tmp2)) * DB_SortStyle
  else
    if l1 = l2 then Result := 0
      else
        if l1>l2 then
        Result := DB_SortStyle
          else
            Result := -1 * DB_SortStyle;
end;

function TDBTabela.Sortuj(kolumna : String) : TDBTabela;
begin
  result := nil;
  if kolumna = '' then exit;
  result := TDBTabela.Create;
  result.Assign(self);
  DB_Klucz := kolumna;
  Result.Sort(PorownajNapisyListy);
end;

function TDBTabela.WyszukajPosortowane(const s, sort : string; proc : TDBProceduraDodajaca) : integer;
var tmp : TDBTabela;
begin
  tmp := Sortuj(sort);
  Result := Wyszukaj(s, proc, tmp);
  if Assigned(tmp) then tmp.Free;
end;

function TDBTabela.Wyszukaj(const s : string; proc : TDBProceduraDodajaca; ListaPozycjonujaca : TDBTabela = nil) : integer;
// Struktura tablicy brakujcych wyrazw, jesli
// znaleziony true, nie znaleziony false
type tab = array [0..0] of boolean;
     ptab = ^tab;
     
var tmp : TStringList;
    i, j : integer;
    Znaleziono : integer;
    Tzn : ptab;
    list : TDBTabela;

begin
  Result := -1;

  // 1. Tworzenie listy sw
  tmp := TStringList.Create;
  Trim(s);
  j := 1;
  i := 2;
  while (i<Length(s)) do
  begin
    if s[i] = ' ' then
    begin
      tmp.Add(Copy(s, j, i - j));
      j := i + 1;
    end;
    inc(i);
  end;

  // Dodawanie ostatniego wyrazu
  tmp.Add(Copy(s, j, i - j+1));
  GetMem(Tzn, tmp.Count * sizeof(boolean));
  
  // 2. Dla kadego wyrazu z listy znald wartosc w badanym rekordzie, jesli
  //    sie zgadza, usun wyraz z listy

  if Assigned(ListaPozycjonujaca) then List := ListaPozycjonujaca
    else List := Self;

  List.Start;

  while not List.Koniec do
  begin
    // Nie znaleziono zadnego wyrazu
    FillChar(Tzn^, tmp.Count * sizeof(boolean), 0);
    Znaleziono := 0;

    for i := tmp.Count -1 downto 0 do
    // Jesli w rekordach bieacej pozycji tabeli jest czesc wyrazu
    // tam[i], wtedy zaznacza i sprawdza czy juz wszysko
    if TRekord(List.Items[List.index]).jestWartosc(tmp[i]) then
    begin
      if not Tzn^[i] then
        begin
          Tzn^[i] := true;
          Inc(Znaleziono);
          if tmp.Count = Znaleziono then break;
        end;
//      if tmp.Count = Znaleziono then break;
    end; // Do znalezionej wartosci

    // Jesli
    if tmp.Count = Znaleziono then
    begin
      Inc(Result);
      proc(TRekord(List.Items[List.index]));
    end;
    
    List.Next;
  end; // while
  
  FreeMem(Tzn, tmp.Count * sizeof(boolean));
end;

function TDBase.Tabela(const _dbNazwa : string) : TDBTabela;
var i : integer;
begin
  Result := nil;
  if not Assigned(dbSystem) then exit;
  dbSystem.Start;
  for i:=0 to dbSystem.Count-1 do
  begin
  if dbSystem.Get(KLUCZ_NAZWA_TAB) = _dbNazwa then
    begin
      if Assigned(AktualizacjaProc) then AktualizacjaProc(Round(i/dbSystem.Count*100));
      Result := TDBTabela(Items[i]);
      Break;
    end;
    dbSystem.Next
  end;
end;

function TDBase.Zapisz(_dbKatalog : string) : integer;
var 
    i : integer;
    tmp : TDBTabela;
begin
  if (_dbKatalog[Length(_dbKatalog)]<>'\') then _dbKatalog := _dbKatalog + '\';

  {$I-}
    MkDir(_dbKatalog);
  {$I+}
  
  dbSystem.ZapiszPlik(_dbKatalog+TABELA_SYSTEMOWA+'.'+DB_ROZSZERZENIE);
  dbSystem.Start;

  for i:=0 to dbSystem.Count-1 do
    begin
      tmp := Items[i];
      if Assigned(AktualizacjaProc) then AktualizacjaProc(Round(i/dbSystem.Count*100));
      if Assigned(tmp) then
        tmp.ZapiszPlik(_dbKatalog+dbSystem.Get(KLUCZ_NAZWA_TAB)+'.'+DB_ROZSZERZENIE);        
      dbSystem.Next;
    end;

  Result := dbSystem.Count;
end;

function TDBase.Wczytaj(_dbKatalog : string) : integer;
var tmp : TDBTabela;
    i : integer;
begin
  if (_dbKatalog[Length(_dbKatalog)]<>'\') then _dbKatalog := _dbKatalog + '\';

  dbSystem.WczytajPlik(_dbKatalog+TABELA_SYSTEMOWA+'.'+DB_ROZSZERZENIE);
  dbSystem.Start;
  for i:=1 to dbSystem.Count do
    begin
      tmp := TDBTabela.Create;
      tmp.ZwolnijPamiec := true;
      tmp.WczytajPlik(_dbKatalog+dbSystem.Get(KLUCZ_NAZWA_TAB)+'.'+DB_ROZSZERZENIE);
      inherited Add(tmp);
      dbSystem.Next;
    end;

  Result := dbSystem.Count;
end;

function TDBase.Add(_tabela : TDBTabela) : integer;
var r : TRekord;
begin
  // Dodawanie tabeli do bazy danych
  Result := inherited Add(_tabela);
  r := TRekord.Create;
  r.Add(KLUCZ_NAZWA_TAB, _tabela.nazwa);
  dbSystem.Add(r);
end;

function TDBase.Query(const _sql : string) : TResult;
begin
  Result := nil;
end;

constructor TDBase.Create;
begin
  inherited;
  dbSystem := TDBTabela.Create;
  dbSystem.nazwa := TABELA_SYSTEMOWA;
  AktualizacjaProc := nil;
end;

destructor TDBase.Free;
begin
  dbSystem.Free;
end;

procedure TDBTabela.Start;
begin
  index := 0;
  if Count<=0 then exit;

  if (Get('Del')<>'') or (Assigned(Filter) and not Filter(TRekord(Items[0]))) then Next;
end;

function TDBTabela.GetF(const klucz : string) : real;
begin
  Result := 0;
  if (index>-1) and (index<Count) then
    Result := Liczba(TRekord(Items[index]).Get(klucz));
end;

function TDBTabela.GetI(const klucz : string) : integer;
begin
  Result := 0;
  if (index>-1) and (index<Count) then
    Result := StrToIntOk(TRekord(Items[index]).Get(klucz));
end;

function TDBTabela.Get(const klucz : string) : string;
begin
  Result := '';
  if (index>-1) and (index<Count) then
    Result := TRekord(Items[index]).Get(klucz);
end;

function TDBTabela.Koniec : boolean;
begin
  Result := index >= Count;
end;

function TDBTabela.Poczatek : boolean;
begin
  Result := index <= 0;
end;

function TDBTabela.Prev : integer;
begin
  dec(index);

  while (index > 0 ) and ((not TRekord(Items[index]).Enabled) or
        (Assigned(Filter) and not Filter(TRekord(Items[index]))))
     do
       dec(index);

  if not TRekord(Items[index]).Enabled then Next;
  // Wychodzi gdy doszedl do konca listy, lub moze uzyc biezacego elementu
  Result := index;
end;

function TDBTabela.Next : integer;
begin
  inc(index);

  while (index < Count ) and ((not TRekord(Items[index]).Enabled)  or
        (Assigned(Filter) and not Filter(TRekord(Items[index]))))
    do
      inc(index);
  
  // Wychodzi gdy doszedl do konca listy, lub moze uzyc biezacego elementu
  Result := index;
end;

function PorownajIndeks(C1, C2 : Pointer; index : integer ) : integer;
var i : integer;
begin
  i := StrToIntOk(TRekord(TDBTabela(C1).Items[index]).Get('Id'));
  if i > integer(C2^) then Result := 1 else
  if i < integer(C2^) then Result := -1 else
    Result := 0;
end;

function TDBTabela.GetIdPos(_id : integer) : integer;
var i : integer;
begin
  Result := -1;
  
  if Self = nil then
    exit;

  if _id <= 0 then exit;
  Result := WyszukiwanieBinarne(self, @_id, PorownajIndeks, Count);
  if Result=-1 then
  for i:=0 to Count-1 do
    if StrToIntOk(TRekord(Items[i]).Get('Id')) = _id then
    begin
      Result := i;
      break;
    end;
end;


function TDBTabela.GetId(_id : integer) : TRekord;
var i, j : integer;
begin
  Result := nil;
  if _id = 0 then exit;
  
  //Wyszukiwanie binarne najpierw
  j := WyszukiwanieBinarne(self, @_id, PorownajIndeks, Count);
  if j>-1 then Result := TRekord(Items[j]);

  // Gdy nie znajdzie wyszukiwanie po kolei
  if not Assigned(Result) then
  for i:=0 to Count-1 do
    if StrToIntOk(TRekord(Items[i]).Get('Id')) = _id then
    begin
      Result := TRekord(Items[i]);
      break;
    end;
end;

function TDBTabela.Add(s, t: string) : integer;
var tmp : TRekord;
begin
  Result := -1;
    
  if (index>=0) and (index<count) then
    begin
      tmp := Items[index];
      if Assigned(tmp) then
        Result := tmp.Add(s, t);
    end;
end;

function TDBTabela.Add(s: string; r : real) : integer;
begin
  Result := Add(s, Napis(r));
end;

function TDBTabela.Add(s: string; i : integer) : integer;
begin
  Result := Add(s, IntToStr(i));
end;

function TDBTabela.Add(s: string; b : boolean) : integer;
begin
  Result := Add(s, integer(b));
end;


function TDBTabela.Add(_rekord : TRekord) : integer;
var id, idt : integer;
    tmp : TRekord;
begin
  Result := -1;

  {Result := inherited Add(_rekord);
  exit;}

  //Tylko gdy cos jest na liscie
  if _rekord.Count>0 then
  begin
    id := _rekord.GetId('Id');

    // Gdy w podawanym rekordzie jest numer Id
    if id>-1 then
    begin
      // Prbujemy do odnalec w bazie danych
      if not Loading then
        idt := GetIdPos(_rekord.Id)
      else
        idt := -1;

      // Jesli znajdziemy
      if (idt>-1) then
      begin
        // Zwalniamy stary wpis rekordu
        tmp := TRekord(Items[idt]);
        // Zapisujemy nowy
        if tmp <> _rekord then
        begin
          Items[idt] := _rekord;
          tmp.Free;
        end;
        
        Result := idt;
      end else
      // Jesli nie byo w caej bazie dodajemy jako now pozycj
        Result := inherited Add(_rekord);

    // jesli nie bylo podanego nr w rekordzie te dodajemy
    end else
      Result := inherited Add(_rekord);

    // Tworzenie auto indeksu jesli nie ma
    if id = -1 then
    begin
      _rekord.Add('Id', nast_index);
      Inc(nast_index);
    end else
    // Jesli jest to w razie gdyby licznik by mniejszy od nowo wstawionego rekordu, dodajemy go
      nast_index := Max (nast_index, StrToInt(PPole(_rekord.Items[id])^.sWartosc) + 1);


  end else
    _rekord.Free;

end;

procedure TDBTabela.WczytajPlik(const _dbNazwaPliku : string);
var tmp : TStringList;
begin
  // Tworzenie struktury danych w pamici
  tmp := TStringList.Create;

  try
    Loading := false;
    // Wczytanie z pliku
    Koder_LoadFromFile(_dbNazwaPliku, tmp);
    // Jeli obsugujemy pliki tekstowe
    if DB_ODCZYTUJ_TXT then
      tmp.LoadFromFile(ChangeFileExt(_dbNazwaPliku, '.txt'));

    // Pobiera dane z bufora
    PobierzDane(tmp);

    nazwa := _dbNazwaPliku;
    Loading := true;

  finally
    // Bd odczytu
    tmp.Free;

  end;

end;

function TDBTabela.WczytajPlikCzesciowy(const _dbNazwaPliku: string;
  out_p: TProceduraOdbierajacaZKodera): Boolean;
var kod : TKoderCzesciowy;
begin
  kod := TKoderCzesciowy.Create;
  kod.out_proc := out_p;

  Result := kod.WczytajZPliku(_dbNazwaPliku);
  kod.Free;
end;

procedure TDBTabela.WczytajRES(res: TResourceStream);
var tmp : TStringList;
begin
  // Tworzenie struktury danych w pamici
  tmp := TStringList.Create;

  try
    Loading := false;
    // Wczytanie z pliku
    Koder_LoadFromRES(res, tmp);

    // Pobiera dane z bufora
    PobierzDane(tmp);

    nazwa := 'TResourceStream';
    Loading := true;

  finally
    // Bd odczytu
    tmp.Free;

  end;
end;

procedure TDBTabela.ZapiszPlik(const _dbNazwaPliku : string);
var tmp : TStringList;
    i, j: Integer;
    r : TRekord;
begin
  try
    // Tworzenie listy wyrazw najczciej
    // wystpujcych w koderze
    r := TRekord.Create;

    KODER_LISTA_WYRAZOW.Clear;
    KODER_LISTA_WYRAZOW.Add('"; ');
    KODER_LISTA_WYRAZOW.Add('"; '#13#10);

    // Bd to wszystkie klucze rekordu
    for i := 0 to Count - 1 do
    for j := 0 to TRekord(Items[i]).Count - 1 do
      r.Add(PPole(TRekord(Items[i]).Items[j])^.sKlucz, '');

    for i := 0 to r.Count - 1 do
      KODER_LISTA_WYRAZOW.Add(PPole(r.Items[i])^.sKlucz+'= "');

    r.Free;
    tmp := TStringList.Create;
    ZwrocDane(tmp);

    // Zapisywanie zakodowanych i spakowanych
    // danych
    Koder_SaveToFile(_dbNazwaPliku, tmp);

    // Jeli obsugujemy pliki tekstowe
    if DB_ZAPISUJ_TXT then
        tmp.SaveToFile(ChangeFileExt(_dbNazwaPliku, '.txt'));


    tmp.Free;

  except
    // Bd odczytu
  end;
end;

function TDBTabela.ZapiszPlikCzesciowy(const _dbNazwaPliku: string;
  in_p: TProceduraDodajacaDoKodera): Boolean;
var kod : TKoderCzesciowy;
begin
  kod := TKoderCzesciowy.Create;
  kod.in_proc := in_p;

  Result := kod.ZapiszDoPliku(_dbNazwaPliku);
  kod.Free;
end;

function TDBTabela.ZnajdzKlucz(const key: string; val: Real): TRekord;
var
  i: Integer;
begin
  Result := nil;
  Start;
  for i := 0 to Count - 1 do
    begin
      if GetF(key) = val then
        begin
          Result := TRekord(Items[i]);
          exit;
        end;
      Next;
    end;
end;

function TDBTabela.ZnajdzKlucz(const key, val: string): TRekord;
var
  i: Integer;
begin
  Result := nil;
  Start;
  for i := 0 to Count - 1 do
    begin
      if Get(key) = val then
        begin
          Result := TRekord(Items[i]);
          exit;
        end;
      Next;
    end;
end;

procedure TDBTabela.Clear;
var
  i: Integer;
  tmp : TRekord;
begin
  for i := Count - 1 downto 0 do
  begin
    tmp := TRekord(Items[i]);
    if ZwolnijPamiec then tmp.Free;

    Delete(i);
  end;

  inherited;
end;

constructor TDBTabela.Create;
begin
  index := 0;
  nast_index := 1;
  ZwolnijPamiec := true;
  Filter := nil;
end;


destructor TDBTabela.Destroy;
{var
  i: Integer;}
begin
  {for i := Count - 1 downto 0 do
  begin
    TRekord(Items[i]).Free;
    Items[i] := nil;
  end;}

  inherited ;
end;

procedure TDBTabela.ZwrocDane(var _tekst : TStringList);
var i : integer;
begin
  // Nagwek
  _tekst.Add(DB_INFO);
  
  // Dane
  for i := 0 to Count-1 do
    if Assigned(Items[i]) then
      _tekst.Add(TRekord(Items[i]).PobierzCalosc);

end;

function TDBTabela.PobierzId : integer;
begin
  Result := nast_index;
  Inc(nast_index);
end;

procedure TDBTabela.Usun(_id : integer);
var tmp : TRekord;
begin
  tmp := GetId(_id);
  if Assigned(tmp) then
    begin
      // Zaznaczenie usunicia
      //tmp.Add('Del', '1');
      Delete(IndexOf(tmp));
    end;
end;

procedure TDBTabela.PobierzDane(_tekst : TStringList);
var tmp : TRekord;
    i : integer;
begin
   for i := 0 to _tekst.Count-1 do
   if _tekst[i]<>'' then
   begin
     tmp := TRekord.Create(_tekst[i]);
     Add(tmp);
   end;
end;

function TRekord.PobierzCalosc : string;
var tmp : PPole;
    i : integer;
begin
  Result := '';
  for i:= 0 to Count-1 do
  begin
    tmp := PPole(Items[i]);
    Result := Result + tmp^.sKlucz + '= "' + AddSlashes(tmp^.sWartosc) + '"; ';
  end;
end;

function TRekord.GetId(const klucz : string) : integer;
var i : integer;
begin
  Result := -1;
  for i:= 0 to Count-1 do
  begin
    if PPole(Items[i])^.sKlucz = klucz then
    begin
      Result := i;
      Break;
    end;
  end;
end;


function TRekord.GetStream(const klucz: string): TStringStream;
var s : string;
begin
  s := Get(klucz);
  Result := TStringStream.Create(s);
end;

function TRekord.Id : integer;
var i : integer;
begin
  Result := 0;
  i := GetId('Id');
  
  if i>=0 then
    Result := StrToIntOk(PPole(Items[i])^.sWartosc);
end;

function TRekord.AddDate(const klucz : string; wartosc : TDateTime) : integer;
begin
  Result := Add(klucz, DateTimeToStr(wartosc));
end;

function TRekord.Add(const klucz : string; wartosc : Real; miejsc: integer = 0) : integer;
begin
  if miejsc>0 then
    wartosc := RoundTo(wartosc, miejsc);

  Result := Add(klucz, Napis(wartosc));
end;

function TRekord.Add(const klucz : string; wartosc : boolean) : integer; 
begin
  Result := Add(klucz, Napis(Integer(wartosc)));
end;


function TRekord.Add(const klucz : string; wartosc : integer) : integer;
var tmp : PPole;
    id : integer;
begin
  Result := -1;
  if klucz<>'' then
  begin
    id := GetId(klucz);

    if id <> -1 then
      tmp := PPole(Items[id])
    else
      New(tmp);

    if id = -1 then
      tmp^.sKlucz := klucz;

    tmp^.sWartosc := IntToStr(wartosc);

    if id = -1 then
      Result := inherited Add(tmp)
    else
      Result := id;
  end;
end;

function TRekord.Add(const klucz, wartosc : string) : integer;
var tmp : PPole;
    id : integer;
begin
  Result := -1;
  if (klucz<>'') then
  begin
    id := GetId(klucz);

    if id <> -1 then
      tmp := PPole(Items[id])
    else
      New(tmp);

    if id = -1 then
      tmp^.sKlucz := klucz;

    tmp^.sWartosc := wartosc;
    if id = -1 then
      Result := inherited Add(tmp)
    else
      Result := id;
  end;{ else
    if klucz<>'' then
      inherited Delete(GetId(klucz));}
end;

function TRekord.jestWartosc(const _wartosc : string) : boolean;
var i : integer;
    tmp : PPole;
    ts : string;
begin
  Result := false;
  ts := UpperCase(_wartosc);
  for i:= 0 to Count-1 do
  begin
    tmp := Items[i];
    if Pos(ts, UpperCase(tmp^.sWartosc))>0 then
    begin
      Result := true;
      Break;
    end;
  end;
end;

function TRekord.Klonuj: TRekord;
var
  i: Integer;
begin
  Result := TRekord.Create;

  // Skopiowanie wszystkich pl
  for i := 0 to Count - 1 do
  if Assigned(Items[i]) then
    begin
      Result.Add(PPole(Items[i])^.sKlucz, PPole(Items[i])^.sWartosc);
    end;
end;

function TRekord.GetF(const klucz : string) : real;
begin
  Result := Liczba(Get(klucz));
end;

function TRekord.GetI(const klucz : string) : integer;
begin
  Result := StrToIntOk(Get(klucz));
end;

function TRekord.Get(const klucz : string) : string;
var i : integer;
    tmp : PPole;
begin
  Result := '';
  for i:= 0 to Count-1 do
  begin
    tmp := Items[i];
    if tmp^.sKlucz = klucz then
    begin
      Result := tmp^.sWartosc;
      Break;
    end;
  end;
end;

function TRekord.Enabled : boolean;
begin
  Result := Get('Del') = '';
end;

function TRekord.PobierzKlucz(const s: string; var i:integer) : string;
var j : integer;
begin
  Result := '';
  j:= i;
  while ((i<Length(s)) and (s[i]<>'=')) do
    inc(i);

  if s[i] = '=' then
    Result := Trim(Copy(s, j, i - j));
end;

function TRekord.PobierzWartosc(const s: string; var i:integer) : string;
var j : integer;
    l : integer;
begin
  Result := '';
  
  // Wyszukiwanie pierwszego cudzyslowia
  l := Length(s);
  while ((i<l) and (s[i]<>'"')) do
    inc(i);

  inc(i);
  j:= i;

  // Wyszukiwanie drugiego cudzyslowia
  while ((i<l) and (s[i]<>'"')) do
    inc(i);

  Result := StripSlashes(Copy(s, j, i - j));

  // Wyszukiwanie srednika konczacego
  while ((i<l) and (s[i]<>';')) do
    inc(i);

  inc(i);
end;

constructor TRekord.Create(const s : string);
var i : integer;
    key : string;
begin
  i := 1;

  // Dopoki nie dojdziemy do konca linii
  while (i < Length(s)) do
  begin
    // Dodawanie atrybutu do rekordu
    // Aby wymusi, e najpierw pobierzemy klucz
    key := PobierzKlucz(s, i);
    Add(key, PobierzWartosc(s, i));
  end;
end;

procedure TRekord.DodajZeStringa(const s : string);
var i : integer;
    key : string;
begin
  i := 1;
  // Dopoki nie dojdziemy do konca linii
  while (i < Length(s)) do
  begin
    // Dodawanie atrybutu do rekordu
    // Aby wymusi, e najpierw pobierzemy klucz
    key := PobierzKlucz(s, i);
    Add(key, PobierzWartosc(s, i));
  end;

end;

procedure TRekord.Clear;
var
  i: Integer;
begin
  for i:= 0 to Count-1 do
  begin
    if Assigned(Items[i]) then
      Dispose(PPole(Items[i]));
    Items[i] := nil;
  end;

  inherited;
end;

constructor TRekord.Create;
begin
  
end;

function AddSlashes(const s:string) : string;
var i : integer;
begin
  Result := '';
  
  for i:=1 to Length(s) do
  if not (s[i] in ['#', '\', '"', #0..#31]) then
    Result := Result + s[i]
  else
  if ((i<=Length(s)) or (s[i] in ['#', '\', '"'])) then
      Result := Result + '#x'+IntToHex(Byte(s[i]),2);
end;

// Zamiana dwucyfrowego hex'a na Byte
function HexToInt(t1, t2 : char) : Byte;
var c1, c2 : char;
begin
  if t1>#64 then c1 := #55 else c1 := #48;
  if t2>#64 then c2 := #55 else c2 := #48;

  Result := (Byte(t1) - Byte(c1)) shl 4 + Byte(t2) - Byte(c2);
end;

function StripSlashes(const s:string) : string;
var i : integer;
begin
  i := 1;

  while i<=Length(s) do
  begin
    if s[i] <> '#' then
      Result := Result + s[i]
    else
    begin
        if Length(s)>=i+3 then
          Result := Result + Char(HexToInt(s[i+2], s[i+3]));
        i := i + 3;
    end;
    i := i + 1;
  end;
end;

initialization
  DB_SortStyle := SORTOWANIE_ROSNACE;
end.
