unit dbKoder;
{
  KODOWANIE I KOMPRESJA PLIKW TEKSTOWYCH
}
interface

uses
  Windows, Classes, SysUtils, math;

const
  KODER_INFO = 'DBText1.0';
  NAGLOWEK_DL = 9 + 4 + 4;

  KODER_PART_INFO = 'DBPart1.0';

  // Nagwek
  NAGLOWEK_PART_DL = 9;

  // rozmiar sownika, ilo sw w sowniku
  SLOWNIK_DL = 4 + 1;

type
  TProceduraDodajacaDoKodera = procedure (sl : TStringList) of object;

  TProceduraOdbierajacaZKodera = procedure (sl : TStringList) of object;

  PCiag = ^TCiag;
  TCiag = record
    Ciag : string;
    Count : integer;
  end;

  TKoderTekstowy = class(TList)
    function DodajDoListy(const ciag : string) : integer;
    constructor Create;
    destructor  Free;
  end;

  TKoderCzesciowy = class(TList)

    FH : Integer;
    in_proc : TProceduraDodajacaDoKodera;
    out_proc : TProceduraOdbierajacaZKodera;
    wyrazy : TStringList;

    function DodajDoListy(const ciag : string) : integer;
    function ZapiszDoPliku(const FileName : string) : Boolean;
    function WczytajZPliku(const FileName : string) : Boolean;
    constructor Create;
    destructor Destroy; override;
  end;

  TZnak = record
    znak  : Char;
    ile : Integer;
  end;

  PIntegerArray = ^TIntegerArray;
  TIntegerArray = array [0..255] of TZnak;

var
  Slownik : array [0..255] of TStringList;
  KODER_LISTA_WYRAZOW : TStringList;

  
function SumaKontrolna(const s : string) : LongWord;

function Koder_ZliczZnaki(tmp : PAnsiChar) : PIntegerArray;
function Koder_SaveToFile(const FileName : string; tmp : TStringList) : Boolean;
function Koder_LoadFromFile(const FileName : string; tmp : TStringList) : Boolean;
function Koder_LoadFromRES(res : TResourceStream; tmp : TStringList) : Boolean;

function MyStrComp(const s1: string; s2 : PChar) : boolean;

procedure ClearAll;
procedure Init;
procedure FreeAll;

implementation
var
    id_slownik : Integer;
    
procedure SelectionSort(var ia : PIntegerArray);
var
  i, j : Integer;
  k : TZnak;
  min : Integer;
begin
  for i:=0 to 255 do
  begin
    min := i;
    for j:=i+1 to 255 do
      if (ia[min].ile < ia[j].ile) then
        min := j;
    k := ia[min];
    ia[min] := ia[i];
    ia[i] := k;
  end;
end;

function ZwrocNaglowek(Dane : string) : string;
type
  TWordArray = array[0..3] of char;
begin
  Result := KODER_INFO + TWordArray(SumaKontrolna(Dane)) + #0#0#0#0;
end;

function ZwrocTablice(tmp : PAnsiChar) : string;
var i : Integer;
    ia  : PIntegerArray;
    maxS : integer;
begin
    Result := '';
    ia := Koder_ZliczZnaki(tmp);
    i := 0;
    while (i < 256) and (ia^[i].ile > 0) do
    begin
      Slownik[Byte(ia^[i].znak)].AddObject(ia^[i].znak, TObject(i));
      Result := Result + Char(1) + ia^[i].znak;
      Inc(i);
    end;

    Dispose(ia);

  id_slownik := i;
  maxS := 0;
  if Assigned(KODER_LISTA_WYRAZOW) then
    maxS := Min(KODER_LISTA_WYRAZOW.Count, 256-id_slownik);

  for i := id_slownik to id_slownik + maxS - 1 do
    begin
      Slownik[Byte(KODER_LISTA_WYRAZOW[i - id_slownik][1])].AddObject(KODER_LISTA_WYRAZOW[i - id_slownik], TObject(i));
      Result := Result + Char(Length(KODER_LISTA_WYRAZOW[i - id_slownik])) + KODER_LISTA_WYRAZOW[i - id_slownik];
    end;

  id_slownik := id_slownik + maxS;

  Result := Char(id_slownik) + Result;
end;

function Koder_ZliczZnaki(tmp : PAnsiChar) : PIntegerArray;
var
  ia  : PIntegerArray;
  i : Integer;

begin
  New(ia);

  for i:= 0 to 255 do
  begin
    ia^[i].znak := Chr(i);
    ia^[i].ile := 0;
  end;

  for i:= 0 to Length(tmp)-1 do
    Inc(ia[Byte(tmp[i])].ile);

  SelectionSort(ia);
  Result := ia;

end;

function TKoderTekstowy.DodajDoListy(const ciag : string) : integer;
var tmp : PCiag;
begin
  New(tmp);
  tmp^.Ciag := ciag;
  tmp^.Count := 1;
  Result := Add(tmp);
end;

constructor TKoderTekstowy.Create;
begin
end;    

destructor  TKoderTekstowy.Free;
begin
end;

function MyStrComp(const s1: string; s2 : PChar) : boolean;
var i, l : Integer;
begin
  l := Length(s1);
  i := 1;
  
  while (i<l) and (s1[i] = Char(s2^)) do
  begin
      inc(i);
      inc(s2);
  end;

  Result := i >= l;
end;

function ZwrocDane(const text : string) : string;
var
  MaxD : integer;
  a, i, j : Integer;
  b : byte;
  buff : string[202];
//  ts : string;
begin
  result := '';
  buff := '';

  j := 1;
  i := 0;

  while j < Length(text) do
  begin
    MaxD := 0;
    b := Byte(text[j]);
    if Assigned(Slownik[b]) then
    for a := 0 to Slownik[b].Count - 1 do

    // Jeli pasuje kolejna literka wyrazu, zaznaczamy, e
    // mona go bdzie wykorzysta
     if MyStrComp(Slownik[b].Strings[a], @text[j])
     then
      begin
        if MaxD < Length(Slownik[b][a]) then
        begin
          MaxD := Length(Slownik[b][a]);
          i := Integer(Slownik[b].Objects[a]);
        end;
      end;

    // Operacje na buforze
    buff := buff + Char(i);
    if Length(buff) > 200 then
    begin
      Result := Result + buff;
      buff := '';
    end;

    // Przejcie do kolejnego wyrazu
    inc(j, MaxD);
  end;

  // Przeadowanie bufora tymczasowego do pamici zwrotnej
  if Length(buff) <= 200 then
    begin
      Result := Result + buff;
      buff := '';
    end;
end;

// Funkcja tworzy string, o strukturze takiej, jak bdzie wyglda
// nowo utworzony plik. Wymaga pliku tekstowego podzielonego na wiersze
function PobierzDanePliku(tmp : TStringList) : string;
var ac : PAnsiChar;
begin
  // Pobiera tekst
  ac := tmp.GetText;
  // Tworzenie trzech blokw pliku:
  // 1. Nagwka
  // 2. Tablicy wyrazw
  // 3. Zakodowanych danych
  result := ZwrocNaglowek(ac) + ZwrocTablice(ac) + ZwrocDane(ac);
  // Zwalnia pami tekstu
  strDispose(ac);
end;


  function Right(const str : string; count : Integer) : string;
  begin
    count := Min(Length(str), count);
    SetLength(result, count);
    Move(str[Length(str) - count + 1], result[1], count);
  end;
  
// Odczytuje dane ze stringa do TStringList, jako plik tekstowy
function OdczytajDanePliku(tmp : TStringList; const s : string) : Boolean;
var suma : LongWord;
    tabdl : LongWord;
    Header : string;
    Tablica : string;
    ts : string;
    i, poz: Integer;
    b : Byte;
    sl : string;
begin
 
  Result := false;
  tmp.Clear;
  // Kopiowanie nagwka
  Header := Copy(s, 1, NAGLOWEK_DL);
  // Sprawdzanie znacznika pliku
  // musi by to co w KODER_INFO
  if Copy(Header, 1, Length(KODER_INFO)-3) <> Copy(KODER_INFO, 1, Length(KODER_INFO)-3) then exit;
  // Pobranie sumy kontrolnej
  ts := Copy(Header, Length(KODER_INFO)+1, 4);
  suma := PLongWord(@ts[1])^;
  ts:= '';
  // Pobranie dugoci tablicy sownika
  tabdl := Byte(s[NAGLOWEK_DL+1]);
  // Ustawienie kursora na dugo pierwszego sowa
  poz := NAGLOWEK_DL + 1 + 1;

  // Czycimy list wyrazw sownika
  KODER_LISTA_WYRAZOW.Clear;

  for i := 0 to tabdl - 1 do
  begin
    b := Byte(s[poz]);
    Tablica := Copy(s, poz+1, b);
    Inc(poz, b + 1);
    KODER_LISTA_WYRAZOW.Add(Tablica);
  end;

  i := 1;

  while poz<=Length(s) do
  begin
    b := Byte(s[poz]);
    if b<KODER_LISTA_WYRAZOW.Count then
      ts := ts + KODER_LISTA_WYRAZOW.Strings[Byte(s[poz])];

      sl := Right(ts, 2);

    if sl = #$D#$A then
    begin
       tmp.Add(Copy(ts, i, Length(ts) - i - 1));
       i := Length(ts) + 1;
    end;
      
    inc(poz);
  end;

  KODER_LISTA_WYRAZOW.Clear;
 
  // Jeli suma kontrolna si zgadza, tylko wtedy napis jest dodawany
  if (SumaKontrolna(ts) = suma) or (Length(ts)>20000000) then
    Result := true
  else
    tmp.Clear;
end;

function Koder_LoadFromRES(res : TResourceStream; tmp : TStringList) : Boolean;
var
  s : string;
begin
  Result := false;
  try
    if not Assigned(res) then exit;

    // Ustawienie dugoci stringa
    SetLength(s, res.Size);
    // Wczytanie do niego zawartoci bufora pamici z pliku
    res.ReadBuffer(s[1], res.Size);
    // Przetworzenie danych na TStringList
    // Jeli co pjdzie nie tak, lista bdzie pusta
    Result := OdczytajDanePliku(tmp, s);
  except
  end;
end;

// Wczytywanie pliku zakodowanego do TStringList
function Koder_LoadFromFile(const FileName : string; tmp : TStringList) : Boolean;
var
  ts : TMemoryStream;
  s : string;
begin
  Result := false;
  try
    if not FileExists(FileName) then exit;
    // Utworzenie bufora odfczytujcego
    ts := TMemoryStream.Create;
    // Wczytanie z pliku
    ts.LoadFromFile(FileName);
    // Ustawienie dugoci stringa
    SetLength(s, ts.Size);
    // Wczytanie do niego zawartoci bufora pamici z pliku
    ts.ReadBuffer(s[1], ts.Size);
    // Przetworzenie danych na TStringList
    // Jeli co pjdzie nie tak, lista bdzie pusta
    Result := OdczytajDanePliku(tmp, s);
    ts.Free;
  except
  end;
end;

// Zapisywanie TStringList do zakodowanego pliku binarnego
function Koder_SaveToFile(const FileName : string; tmp : TStringList) : Boolean;
var
  ts : TMemoryStream;
  s : string; 
begin
  Result := false;
  try
    ClearAll;
    // Tworzenie bufora pamici do zapisania
    ts := TMemoryStream.Create;
    // Utworzenie pliku w pamici
    s := PobierzDanePliku(tmp);
    // Przepisanie do bufora
    ts.Write(s[1], Length(s));
    // Zapisanie do pliku
    ts.SaveToFile(FileName);
    // Zwolnienie bufora
    ts.Free;
    Result := true;
  except
  end;
end;

// Oblicza sum kontroln striga, jako 4 bajtow
// Sumowane s kolejne bajty sumy i odpowiednie (co 4)
// bajt stringa
function SumaKontrolna(const s : string) : LongWord;
var
  i, j : LongWord;
  len : LongWord;
  a : array[1..4] of Byte;
begin
  result := 0;

  i := 1;
  len := Length(s);
  // Najpierw 32-bitowe tworzenie sumy za pomoc xor
  while(i + 4 <= len) do
  begin
    result := result xor PLongWord(@s[i])^;
    Inc(i, 4);
  end;
  
  FillChar(a, SizeOf(a), 0);
  j := 1;
  // Potem 8 bitowo reszta z dzielenia przez 4
  while (i <= len) do
  begin
    a[j] := Ord(s[i]);
    Inc(i);
    Inc(j);
  end;

  result := result xor PLongWord(@a[1])^;
end;

// Przydzielanie pamici sownikowi
procedure Init;
var i : integer;
begin
  for i := 0 to 255 do
    Slownik[i] := TStringList.Create;
end;

// Zwalnianie caej pamici
procedure FreeAll;
var i : integer;
begin
  for i := 0 to 255 do
    Slownik[i].Free;
end;

// Czyszczenie zawartoci sownikw
procedure ClearAll;
var i : integer;
begin
  for i := 0 to 255 do
    Slownik[i].Clear;
end;

// Tworzenie schowka na wyrazy, ktre bdziemy dodawa
// do sownika
{ TKoderCzesciowy }

constructor TKoderCzesciowy.Create;
begin
  wyrazy := TStringList.Create;
end;

destructor TKoderCzesciowy.Destroy;
begin
  wyrazy.Free;

  inherited;
end;

function TKoderCzesciowy.DodajDoListy(const ciag: string): integer;
begin
  Result := wyrazy.Add(ciag);
end;


function TKoderCzesciowy.WczytajZPliku(const FileName: string): Boolean;
var buf, sl, ts : string;
    sl_dl, dl_bl : LongInt;
    i_s, b : Byte;
    i, poz, br : Integer;
    stl : TStringList;

begin
  Result := false;
  stl := TStringList.Create;

  try
    // Otwarcie pliku do odczytu
    FH := FileOpen(FileName, fmOpenRead);
    FileRead(FH, buf, NAGLOWEK_PART_DL);

    // Badanie poprawnoci formatu pliku
    if Copy(buf, 1, Length(KODER_PART_INFO)-3) <>
       Copy(KODER_PART_INFO, 1, Length(KODER_PART_INFO)-3)
        then exit;


    // Powtarzanie do momentu wczytania wszystkiego
    repeat

      //Wczytanie dugoci sownika
      br := FileRead(FH, buf, SLOWNIK_DL);

      // Koniec wczytywania
      if br = 0 then
        break;

      //Sprawdzanie dugoci sownika i iloci sw
      sl_dl := PLongWord(@buf[1])^;
      i_s := Byte(buf[5]);

      // Wczytanie sownika
      FileRead(FH, buf, sl_dl);

      // Nowa tablica wyrazw
      wyrazy.Clear;

      poz := 1;
      for i := 0 to i_s - 1 do
      begin
        b := Byte(buf[poz]);
        wyrazy.Add(Copy(buf, poz+1, b));
        Inc(poz, b + 1);
      end;

      // Wczytanie dugoci bloku
      br := FileRead(FH, buf, 4);

      if br = 4 then
      begin
        // Obliczenie dugoci bloku, wczytanie caego bloku
        dl_bl := PLongWord(@buf[1])^;
        br := FileRead(FH, buf, dl_bl);

        // Jeli by bd przy wczytywaniu wychodzimy z ptli
        if br <> dl_bl then
          break;

        // Dekodowanie bloku
        poz := 1;

        while poz<=Length(buf) do
        begin
          // Pobranie indeksu wyrazu
          b := Byte(buf[poz]);

          // Jeli taki jest
          if b<wyrazy.Count then

            // Dodajemy do tymczasowego stringa
            ts := ts + wyrazy.Strings[Byte(buf[poz])];

            // Badamy ostatnie 2 znaki sowa
            sl := Right(ts, 2);

            // Jeli enter to dodajemy lini
            if sl = #$D#$A then
            begin
               // Dodanie rekordu na list przygotowywan do wyjcia
               stl.Add(ts);

               ts := '';
            end;

          // Do nastpnego znaku
          inc(poz);
        end;

        // Procedura odbiera dane w postaci listy stringw
        out_proc(stl);

        stl.Clear;
      end;

    until br = 0;

    Result := true;

  finally
    stl.Free;
    FileClose(FH);
  end;

end;

function TKoderCzesciowy.ZapiszDoPliku(const FileName: string): Boolean;
var tmp : TStringList;
    ts : string;
    ac : PAnsiChar;
    lw : LongWord;

begin
  Result := false;
  tmp := TStringList.Create;

  try
    // Otwarcie pliku do odczytu
    FH := FileCreate(FileName);
    FileWrite(FH, KODER_PART_INFO, NAGLOWEK_PART_DL);

    repeat
      tmp.Clear;

      // Pobiera tekst
      in_proc(tmp);

      if tmp.Count > 0 then
        begin
          ac := tmp.GetText;

          // Zapis sownika
          ts := ZwrocTablice(ac);
          lw := Length(ts);
          // Rozmiar
          FileWrite(FH, lw, 4);
          // Dane
          FileWrite(FH, ts[1], lw);

          // Zapis Bloku
          lw := Length(ts);
          // Rozmiar
          FileWrite(FH, lw, 4);
          // Dane
          ts := ZwrocDane(ac);
          FileWrite(FH, ts[1], lw);

          strDispose(ac);
        end;

    until tmp.Count = 0;

    // Zwalnia pami tekstu

  finally
    tmp.Free;
    FileClose(FH);
  end;

end;

initialization
  KODER_LISTA_WYRAZOW := TStringList.Create;
  Init;

finalization
  KODER_LISTA_WYRAZOW.Free;
  FreeAll;
end.
