struct
        TDane
        {
          char                  Imie[30];
          char                  Nazwisko[30];
          char                  Telefon[16];
          char                  Miejscowosc[30];
          char                  Wiek[3];
          char                  Zawod[16];

        };

struct
        THeaderDataBaseFile
        {
          char                  Znacznik[4]; //Znacznik pliku z baz danych
          char                  Wersja[4]; //Wersja bazy danych
        __int32                 Wpisow; //Liczba wpisow danych osobowych w bazie                 
        };

class
        //Lista osob
        TPerson
        {
          public:
          
          TPerson *             Prev;
          TPerson *             Next;

          TDane                 Dane;
        };

class
        TDataBase
        {

          public:
          
             AnsiString         FileName;
             TPerson *          Add(TDane * DaneOsobowe);
             TPerson *          Insert(TPerson * Tmp2, TPerson * Tmp3, TPerson * Temp);
             TPerson *          GetData(int nr);

             int                SaveToFile(const char * FileName);
             int                LoadFromFile(const char * FileName);
             int                Count();  


             //--------------------------------------
             
             TPerson *          First;
             TPerson *          Last;

             
        };


int CompareStrings(char * S1, char * S2)
{
  int i=0;
  // Sprawdza doploki litera w badanych napisach jest taka sama
  // lub sie skonczyl
  while (*(S1+i) && *(S2+i) && (*(S1+i)==*(S2+i))) i++;
  return (*(S1+i)==*(S2+i)? 0 : *(S1+i)>*(S2+i)? 1 : 2);
};

TPerson * TDataBase::Insert(TPerson * Tmp2, TPerson * Tmp3, TPerson * Temp)
{
  //Wstawia Nowe dane pomiedzy Tmp2 a Tmp3
  if (Tmp2) Tmp2->Next = Temp;
  Temp->Prev = Tmp2;

  if (Tmp3) Tmp3->Prev = Temp;
  Temp->Next = Tmp3;

  return Temp;
};

int TDataBase::SaveToFile(const char * FileName)
{
  //Zapis bazy danych do pliku
  THeaderDataBaseFile Header;

  strcpy(Header.Znacznik, "DaBa");
  strcpy(Header.Wersja, "1.0");

  FILE * fp;
  fp = fopen(FileName, "w");

  int count = Count();
  Header.Wpisow = count;
  fwrite(Header.Znacznik, sizeof(Header), 1, fp);

  TPerson * Temp = First;


  for (int i=0;i<count;i++)
  {
    fwrite(Temp->Dane.Imie, sizeof(TDane), 1, fp);
    Temp = Temp->Next;
  };

  fclose(fp);
  
  return 0;
};

int TDataBase::LoadFromFile(const char * FileName)
{

  THeaderDataBaseFile Header;
  TDane Temp;


  FILE * fp;
  fp = fopen(FileName, "r");
  fread(&Header, sizeof(Header), 1, fp);

  int count = Header.Wpisow;
  
  for (int i=0;i<count;i++)
  {
    fread(&Temp, sizeof(TDane), 1, fp);
    Add(&Temp);
  };

  fclose(fp);

  return 0;
};

int TDataBase::Count()
{
  int i = 0;
  TPerson * Temp = First;
  while (Temp)
  {
    i++;
    Temp = Temp->Next;
  };
  return i;
};

TPerson * TDataBase::GetData(int nr)
{
  int i = 1;
  TPerson * Temp = First;
  while (Temp && (i<nr))
  {
    i++;
    Temp = Temp->Next;
  };
  return Temp;
};

TPerson * TDataBase::Add(TDane * DaneOsobowe)
{
  TPerson * Temp;
  TPerson * Tmp2;
  TPerson * Tmp3;

  //Nowa, pusta struktura
  Temp = new TPerson;
  Temp->Prev = 0;
  Temp->Next = 0;

  Tmp2 = First;
  Tmp3 = 0;

  //Kopiowanie danych do nowej pamieci
  Move(DaneOsobowe, &Temp->Dane, sizeof(TDane));

  //Przeglada liste az do znalezienia wyrazu, ktory powinien byc pozniej
  while (Tmp2 && (CompareStrings((char *) &Tmp2->Dane.Nazwisko, (char *) &Temp->Dane.Nazwisko)!=1))
  {
    if (Tmp2->Next) { Tmp2 = Tmp2->Next; } else break;
  };

  //Do Tmp3 podsawia kolejny element
  if (Tmp2)
    {
      if (Tmp2!=First)
      {
      Tmp3 = Tmp2->Next;
      } else
      {
        Tmp3 = Tmp2;
        Tmp2 = NULL;
        First = Temp;
      };
    } else First = Temp;

  //Wstawia do listy nowy element pomiedzy tmp2 a tmp3
  Insert(Tmp2, Tmp3, Temp);


  
  return Temp;
};